# -*- coding: utf-8 -*-
"""LSTM_gym.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1o435WGz74gQuiTV-MSBtfWDDpxO4LiIT
"""

import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.tree import DecisionTreeClassifier
from sklearn.metrics import accuracy_score, classification_report, confusion_matrix
from sklearn.ensemble import RandomForestClassifier
from sklearn.svm import SVC
import xgboost as xgb
import tensorflow as tf
from tensorflow.keras.models import Sequential
from tensorflow.keras.layers import LSTM, Dense,Dropout
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import LabelEncoder
from sklearn.preprocessing import LabelEncoder, MinMaxScaler
from tensorflow.keras.optimizers import Adam
from tensorflow.keras.callbacks import ModelCheckpoint
from tensorflow.keras.models import load_model

from google.colab import drive
drive.mount('/content/drive')

dir = '/content/drive/MyDrive/Anit/Gym_Posture_Data/train_test'

X_train = np.load(dir + '/X_train.npy')
Y_train = np.load(dir + '/Y_train.npy')

X_test = np.load(dir + '/X_test.npy')
Y_test = np.load(dir + '/Y_test.npy')

print(X_train.shape)
print(Y_train.shape)
print(X_test.shape)
print(Y_test.shape)

X_train_reshaped = X_train.reshape((X_train.shape[0], 30, 33 * 3))


X_train_reshaped.shape

X_train_reshaped = X_train.reshape((X_train.shape[0], 30, 33 * 3))

# Define the LSTM model
model = Sequential()
model.add(LSTM(units=64, input_shape=(30, 33 * 3), return_sequences=True))
model.add(Dropout(0.2))
model.add(LSTM(units=64, return_sequences=True))
model.add(Dropout(0.2))
model.add(Dense(units=64, activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(units=1, activation='sigmoid'))
model.compile(optimizer=Adam(learning_rate=0.001), loss='binary_crossentropy', metrics=['accuracy'])

model.summary()

Y_train = Y_train.reshape(-1, 1)

Y_train.shape

# Train the model
batch_size = 32
epochs = 50

# Define class weights
class_weights = {0: 0.2, 1: 0.8}  # Replace with appropriate weights

# Define a ModelCheckpoint callback to save the best model
checkpoint = ModelCheckpoint("best_model.h5", monitor='val_accuracy', save_best_only=True, mode='max', verbose=1)

# Train the model with the callback
history = model.fit(
    X_train_reshaped,
    Y_train,
    batch_size=batch_size,
    epochs=epochs,
    validation_split=0.2,
    class_weight=class_weights,
    callbacks=[checkpoint]
)

X_test_reshaped = c
Y_test = Y_test.reshape(-1, 1)

print(X_test_reshaped.shape)
print(Y_test.shape)

# Evaluate the best model on the test set
best_model = load_model("best_model.h5")  # Load the best model saved by ModelCheckpoint
test_scores = best_model.evaluate(X_test_reshaped, Y_test)

# Print the test scores
print("Test Loss:", test_scores[0])
print("Test Accuracy:", test_scores[1])

best_model.summary()

X_test[0].shape
(X_test.shape[0], 30, 33 * 3)

X_test_reshaped=X_test.reshape((X_test.shape[0], 30, 33 * 3))

predictions = best_model.predict(X_test_reshaped[0])



predictions=best_model.predict(X_test_reshaped)

best_model

predictions.shape

X_test_reshaped = X_test.reshape((X_test.shape[0], 30, 33 * 3))
X_test_reshaped.shape


# Assuming X_test_reshaped is your test data
predictions = best_model.predict(X_test_reshaped)

# Extract the last prediction for each sequence
final_predictions = predictions[:, -1, 0]

# Print the shape of final_predictions
print("Shape of final_predictions:", final_predictions.shape)

final_predictions>0.9

final_predictions.shape

##LSTM with autoencoder for anomaly detection

# Define LSTM model
lstm_model = Sequential()
lstm_model.add(LSTM(64, input_shape=(10, 33)))
lstm_model.add(Dense(1, activation='sigmoid'))
lstm_model.compile(loss='binary_crossentropy', optimizer='adam')
lstm_model.fit(X_train, y_train, epochs=10)

# Extract LSTM model's output
lstm_output_layer = lstm_model.layers[0]
lstm_output_model = Model(inputs=lstm_model.input, outputs=lstm_output_layer.output)

# Train an autoencoder
autoencoder_model = Sequential()
autoencoder_model.add(Dense(64, activation='relu', input_shape=(64,)))  # Adjust the input shape based on the LSTM output size
autoencoder_model.add(Dense(33, activation='sigmoid'))  # Output layer should match the number of features
autoencoder_model.compile(optimizer='adam', loss='mean_squared_error')

# Train the autoencoder on instances where the LSTM output is zero
zero_output_indices = np.where(y_train == 0)[0]
X_train_zero_output = lstm_output_model.predict(X_train[zero_output_indices])
autoencoder_model.fit(X_train_zero_output, X_train_zero_output, epochs=10)

# Reconstruction error function
def calculate_reconstruction_error(original, reconstructed):
    return np.mean(np.square(original - reconstructed))

# Detect anomalies
X_all_output = lstm_output_model.predict(X_train)
reconstructed_output = autoencoder_model.predict(X_all_output)
reconstruction_errors = [calculate_reconstruction_error(X_all_output[i], reconstructed_output[i]) for i in range(len(X_all_output))]

# Set a threshold for anomaly detection
threshold = 0.1  # You may need to tune this value based on your data and model

# Identify anomalies
anomalies = np.where(reconstruction_errors > threshold)[0]
print("Anomalies:", anomalies)

